/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.renderers.entities.starcrawler;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.st0x0ef.stellaris.client.renderers.entities.starcrawler.StarCrawlerAnim;
import com.st0x0ef.stellaris.common.entities.mobs.StarCrawler;
import com.st0x0ef.stellaris.common.utils.ResourceLocationUtils;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StarCrawlerModel<T extends StarCrawler>
extends HierarchicalModel<StarCrawler> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocationUtils.id("star_crawler"), "main");
    private final ModelPart root;

    public StarCrawlerModel(ModelPart root) {
        this.root = root.getChild("root");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -13.0f, -8.0f, 16.0f, 10.0f, 16.0f, new CubeDeformation(0.0f)).texOffs(0, 26).addBox(-7.0f, -9.0f, -7.0f, 14.0f, 9.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition arm1 = root.addOrReplaceChild("arm1", CubeListBuilder.create().texOffs(48, 48).addBox(-6.0f, -3.9f, 0.0f, 12.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(42, 26).addBox(-5.0f, 4.1f, -2.0f, 10.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)7.0f));
        PartDefinition cube_r1 = arm1.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(48, 64).addBox(0.0f, 0.0f, -3.0f, 5.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)4.3f, (float)4.0f, (float)0.0f, (float)3.1416f, (float)-0.3491f));
        PartDefinition cube_r2 = arm1.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(58, 64).addBox(0.0f, 0.0f, -3.0f, 5.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.0f, (float)4.3f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition limb = arm1.addOrReplaceChild("limb", CubeListBuilder.create().texOffs(48, 0).addBox(-5.0f, -4.3f, 0.25f, 10.0f, 7.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(0, 64).addBox(-4.0f, 2.7f, -0.75f, 8.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.3f, (float)6.75f));
        PartDefinition cube_r3 = limb.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(59, 38).addBox(0.0f, 0.0f, -3.0f, 5.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)3.0f, (float)5.25f, (float)0.0f, (float)3.1416f, (float)-0.3491f));
        PartDefinition cube_r4 = limb.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(57, 16).addBox(0.0f, 0.0f, -3.0f, 5.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)3.0f, (float)4.25f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition hand = limb.addOrReplaceChild("hand", CubeListBuilder.create().texOffs(0, 49).addBox(-4.0f, -3.3f, 0.25f, 8.0f, 6.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(25, 55).addBox(-3.0f, 2.7f, -0.75f, 6.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.1f, (float)8.0f));
        PartDefinition cube_r5 = hand.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(39, 49).addBox(0.0f, 0.0f, -3.0f, 5.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)2.9f, (float)5.25f, (float)0.0f, (float)3.1416f, (float)-0.3491f));
        PartDefinition cube_r6 = hand.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(49, 38).addBox(0.0f, 0.0f, -3.0f, 5.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)2.9f, (float)4.25f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition arm2 = root.addOrReplaceChild("arm2", CubeListBuilder.create().texOffs(48, 48).addBox(-6.0f, -3.9f, 0.0f, 12.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(42, 26).addBox(-5.0f, 4.1f, -2.0f, 10.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-7.0f, (float)-7.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition cube_r7 = arm2.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(48, 64).addBox(0.0f, 0.0f, -3.0f, 5.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)4.3f, (float)4.0f, (float)0.0f, (float)3.1416f, (float)-0.3491f));
        PartDefinition cube_r8 = arm2.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(58, 64).addBox(0.0f, 0.0f, -3.0f, 5.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.0f, (float)4.3f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition limb2 = arm2.addOrReplaceChild("limb2", CubeListBuilder.create().texOffs(48, 0).addBox(-5.0f, -4.3f, 0.25f, 10.0f, 7.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(0, 64).addBox(-4.0f, 2.7f, -0.75f, 8.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.3f, (float)6.75f));
        PartDefinition cube_r9 = limb2.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(59, 38).addBox(0.0f, 0.0f, -3.0f, 5.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)3.0f, (float)5.25f, (float)0.0f, (float)3.1416f, (float)-0.3491f));
        PartDefinition cube_r10 = limb2.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(57, 16).addBox(0.0f, 0.0f, -3.0f, 5.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)3.0f, (float)4.25f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition hand2 = limb2.addOrReplaceChild("hand2", CubeListBuilder.create().texOffs(0, 49).addBox(-4.0f, -3.3f, 0.25f, 8.0f, 6.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(25, 55).addBox(-3.0f, 2.7f, -0.75f, 6.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.1f, (float)8.0f));
        PartDefinition cube_r11 = hand2.addOrReplaceChild("cube_r11", CubeListBuilder.create().texOffs(39, 49).addBox(0.0f, 0.0f, -3.0f, 5.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)2.9f, (float)5.25f, (float)0.0f, (float)3.1416f, (float)-0.3491f));
        PartDefinition cube_r12 = hand2.addOrReplaceChild("cube_r12", CubeListBuilder.create().texOffs(49, 38).addBox(0.0f, 0.0f, -3.0f, 5.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)2.9f, (float)4.25f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition arm3 = root.addOrReplaceChild("arm3", CubeListBuilder.create().texOffs(48, 48).addBox(-6.0f, -3.9f, 0.0f, 12.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(42, 26).addBox(-5.0f, 4.1f, -2.0f, 10.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-7.0f, (float)-7.0f, (float)-3.1416f, (float)0.0f, (float)3.1416f));
        PartDefinition cube_r13 = arm3.addOrReplaceChild("cube_r13", CubeListBuilder.create().texOffs(48, 64).addBox(0.0f, 0.0f, -3.0f, 5.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)4.3f, (float)4.0f, (float)0.0f, (float)3.1416f, (float)-0.3491f));
        PartDefinition cube_r14 = arm3.addOrReplaceChild("cube_r14", CubeListBuilder.create().texOffs(58, 64).addBox(0.0f, 0.0f, -3.0f, 5.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.0f, (float)4.3f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition limb3 = arm3.addOrReplaceChild("limb3", CubeListBuilder.create().texOffs(48, 0).addBox(-5.0f, -4.3f, 0.25f, 10.0f, 7.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(0, 64).addBox(-4.0f, 2.7f, -0.75f, 8.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.3f, (float)6.75f));
        PartDefinition cube_r15 = limb3.addOrReplaceChild("cube_r15", CubeListBuilder.create().texOffs(59, 38).addBox(0.0f, 0.0f, -3.0f, 5.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)3.0f, (float)5.25f, (float)0.0f, (float)3.1416f, (float)-0.3491f));
        PartDefinition cube_r16 = limb3.addOrReplaceChild("cube_r16", CubeListBuilder.create().texOffs(57, 16).addBox(0.0f, 0.0f, -3.0f, 5.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)3.0f, (float)4.25f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition hand3 = limb3.addOrReplaceChild("hand3", CubeListBuilder.create().texOffs(0, 49).addBox(-4.0f, -3.3f, 0.25f, 8.0f, 6.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(25, 55).addBox(-3.0f, 2.7f, -0.75f, 6.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.1f, (float)8.0f));
        PartDefinition cube_r17 = hand3.addOrReplaceChild("cube_r17", CubeListBuilder.create().texOffs(39, 49).addBox(0.0f, 0.0f, -3.0f, 5.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)2.9f, (float)5.25f, (float)0.0f, (float)3.1416f, (float)-0.3491f));
        PartDefinition cube_r18 = hand3.addOrReplaceChild("cube_r18", CubeListBuilder.create().texOffs(49, 38).addBox(0.0f, 0.0f, -3.0f, 5.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)2.9f, (float)4.25f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition arm4 = root.addOrReplaceChild("arm4", CubeListBuilder.create().texOffs(48, 48).addBox(-6.0f, -3.9f, 0.0f, 12.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(42, 26).addBox(-5.0f, 4.1f, -2.0f, 10.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)7.0f, (float)-7.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition cube_r19 = arm4.addOrReplaceChild("cube_r19", CubeListBuilder.create().texOffs(48, 64).addBox(0.0f, 0.0f, -3.0f, 5.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)4.3f, (float)4.0f, (float)0.0f, (float)3.1416f, (float)-0.3491f));
        PartDefinition cube_r20 = arm4.addOrReplaceChild("cube_r20", CubeListBuilder.create().texOffs(58, 64).addBox(0.0f, 0.0f, -3.0f, 5.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.0f, (float)4.3f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition limb4 = arm4.addOrReplaceChild("limb4", CubeListBuilder.create().texOffs(48, 0).addBox(-5.0f, -4.3f, 0.25f, 10.0f, 7.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(0, 64).addBox(-4.0f, 2.7f, -0.75f, 8.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.3f, (float)6.75f));
        PartDefinition cube_r21 = limb4.addOrReplaceChild("cube_r21", CubeListBuilder.create().texOffs(59, 38).addBox(0.0f, 0.0f, -3.0f, 5.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)3.0f, (float)5.25f, (float)0.0f, (float)3.1416f, (float)-0.3491f));
        PartDefinition cube_r22 = limb4.addOrReplaceChild("cube_r22", CubeListBuilder.create().texOffs(57, 16).addBox(0.0f, 0.0f, -3.0f, 5.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)3.0f, (float)4.25f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition hand4 = limb4.addOrReplaceChild("hand4", CubeListBuilder.create().texOffs(0, 49).addBox(-4.0f, -3.3f, 0.25f, 8.0f, 6.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(25, 55).addBox(-3.0f, 2.7f, -0.75f, 6.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.1f, (float)8.0f));
        PartDefinition cube_r23 = hand4.addOrReplaceChild("cube_r23", CubeListBuilder.create().texOffs(39, 49).addBox(0.0f, 0.0f, -3.0f, 5.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)2.9f, (float)5.25f, (float)0.0f, (float)3.1416f, (float)-0.3491f));
        PartDefinition cube_r24 = hand4.addOrReplaceChild("cube_r24", CubeListBuilder.create().texOffs(49, 38).addBox(0.0f, 0.0f, -3.0f, 5.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)2.9f, (float)4.25f, (float)0.0f, (float)0.0f, (float)0.3491f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(StarCrawler entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root.getAllParts().forEach(ModelPart::resetPose);
        this.applyHeadRotation(netHeadYaw);
        this.animateWalk(StarCrawlerAnim.walk, limbSwing, limbSwingAmount, 2.0f, 2.5f);
    }

    private void applyHeadRotation(float headYaw) {
        headYaw = Mth.clamp((float)headYaw, (float)-30.0f, (float)30.0f);
        this.root.yRot = headYaw * ((float)Math.PI / 180);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.root.render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    public ModelPart root() {
        return this.root;
    }
}

